<?php
namespace Database\Seeders;

use App\Models\Company;
use Illuminate\Database\Seeder;
use App\Models\SystemSettingsGroup;
use App\Models\SystemSetting;

class SystemSettingsSeeder extends Seeder
{
    public function run()
    {
        // Define settings data with Arabic names for settings and English for groups/sub-groups
        $data = [
            'Inventory Settings' => [
                'settings' => [
                    'Enable Products' => [
                        'sub_groups' => ['Products'],
                        'translation' => 'تفعيل المنتجات'
                    ],
                    'Enable Services' => [
                        'sub_groups' => ['Services'],
                        'translation' => 'تفعيل الخدمات'
                    ],
                ]
            ],
            'Purchasing Settings' => [
                'settings' => [
                    'Show Username in Purchase Invoices' => [
                        'sub_groups' => ['Purchase Invoices', 'Purchase Orders', 'Printing'],
                        'translation' => 'ظهور اسم المستخدم في فواتير الشراء'
                    ],
                    'Specify Buyer or Service Recipient for Each Item in Invoice' => [
                        'sub_groups' => ['Purchase Invoices', 'Purchase Orders', 'Printing'],
                        'translation' => 'تحديد اسم المشترى او مستلم الخدمة لكل صنف بالفاتورة'
                    ],
                    'Specify Time of Purchase or Service Receipt for Each Item in Invoice' => [
                        'sub_groups' => ['Purchase Invoices', 'Purchase Orders', 'Printing'],
                        'translation' => 'تحديد وقت (الشراء او استلام الخدمة) لكل صنف بالفاتورة'
                    ],
                    'Specify Date of Purchase or Service Receipt for Each Item in Invoice' => [
                        'sub_groups' => ['Purchase Invoices', 'Purchase Orders', 'Printing'],
                        'translation' => 'تحديد تاريخ (الشراء او استلام الخدمة) لكل صنف بالفاتورة'
                    ],
                    'Increase Quantity of Product or Service when Repeated in Invoices' => [
                        'sub_groups' => ['Purchase Invoices', 'Purchase Orders', 'Printing'],
                        'translation' => 'زيادة (كمية / عدد) المنتج او الخدمة عند تكرار طلبه في الفواتير'
                    ],
                    'Show Supplier’s Bank Information in Invoices' => [
                        'sub_groups' => ['Purchase Invoices', 'Purchase Orders', 'Printing'],
                        'translation' => 'ظهور زر تفعيل إظهار البيانات البنكية للمورد في الفواتير'
                    ],
                    'Show Product Category in Invoices and Orders' => [
                        'sub_groups' => ['Purchase Invoices', 'Purchase Orders', 'Printing'],
                        'translation' => 'ظهور تصنيف المنتج في الفواتير والطلبات'
                    ],
                ]
            ],
            'Sales Settings' => [
                'settings' => [
                    'Provide In-Branch Services' => [
                        'sub_groups' => ['Sales', 'Quotations', 'Sales Invoices', 'Quick Sales', 'Printing'],
                        'translation' => 'تقديم الخدمات بالفرع'
                    ],
                    'Provide External Services' => [
                        'sub_groups' => ['Sales', 'Quotations', 'Sales Invoices', 'Quick Sales', 'Printing'],
                        'translation' => 'تقديم خدمات خارجية'
                    ],
                    'Show Username in Sales Invoices' => [
                        'sub_groups' => ['Sales', 'Quotations', 'Sales Invoices', 'Quick Sales', 'Printing'],
                        'translation' => 'ظهور اسم المستخدم في فواتير البيع'
                    ],
                    'Specify Seller or Service Provider for Each Item in Invoice' => [
                        'sub_groups' => ['Sales', 'Quotations', 'Sales Invoices', 'Quick Sales', 'Printing'],
                        'translation' => 'تحديد اسم البائع او مقدم الخدمة لكل صنف بالفاتورة'
                    ],
                    'Specify Time of Sale or Service Delivery for Each Item in Invoice' => [
                        'sub_groups' => ['Sales', 'Quotations', 'Sales Invoices', 'Quick Sales', 'Printing'],
                        'translation' => 'تحديد وقت (البيع او تقديم الخدمة) لكل صنف بالفاتورة'
                    ],
                    'Specify Date of Sale or Service Delivery for Each Item in Invoice' => [
                        'sub_groups' => ['Sales', 'Quotations', 'Sales Invoices', 'Quick Sales', 'Printing'],
                        'translation' => 'تحديد تاريخ (البيع او تقديم الخدمة) لكل صنف بالفاتورة'
                    ],
                    'Increase Quantity of Product or Service when Repeated in Invoices' => [
                        'sub_groups' => ['Sales', 'Quotations', 'Sales Invoices', 'Quick Sales', 'Printing'],
                        'translation' => 'زيادة (كمية / عدد) المنتج او الخدمة عند تكرار طلبه في الفواتير'
                    ],
                    'Show Product Category in Invoices and Orders' => [
                        'sub_groups' => ['Sales', 'Quotations', 'Sales Invoices', 'Quick Sales', 'Printing'],
                        'translation' => 'ظهور تصنيف المنتج في الفواتير والطلبات'
                    ],
                    'Show Customer’s Bank Information in Invoices' => [
                        'sub_groups' => ['Sales', 'Quotations', 'Sales Invoices', 'Quick Sales', 'Printing'],
                        'translation' => 'ظهور زر تفعيل إظهار البيانات البنكية للعميل في الفواتير'
                    ],
                ]
            ]
        ];

      
        foreach (Company::all() as $company) { // Retrieve all companies
            foreach ($data as $groupName => $groupData) {
                $group = SystemSettingsGroup::firstOrCreate(['name' => $groupName]);

                foreach ($groupData['settings'] as $settingName => $settingData) {
                    $setting = SystemSetting::firstOrCreate([
                        'key' => \Str::slug($settingName, '_'),
                        'name' => [
                            'en' => $settingName,
                            'ar' => $settingData['translation']
                        ],
                    ]);

                    foreach ($settingData['sub_groups'] as $subGroup) {
                        \DB::table('company_system_settings')->insert([
                            'company_id' => $company->id, // Insert the company_id for each setting
                            'system_settings_group_id' => $group->id,
                            'system_setting_id' => $setting->id,
                            'sub_group' => $subGroup,
                            'value' => false,
                        ]);
                    }
                }
            }
        }
    }
    
}
